<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('complaints', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->nullable();
            $table->integer('determinationof_vigilance_angle_id')->nullable();
            $table->longText('complaint_description')->nullable();
            $table->longText('remarks')->nullable();
            $table->text('complaint_document')->nullable();
            $table->integer('complaint_status')->default(1)->nullable()->comment('1 for Pending, 2 for Under Processing, 3 for Disposed');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('complaints');
    }
};
